/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.display;

import emulator.GUI.display.VicDisplay;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.Observable;
import java.util.Observer;

public class VicScreen
extends BufferedImage
implements VicDisplay {
    private Dimension screen_size;
    private Dimension pixel_size;
    private int lock = 0;
    private int[] colors;
    private ObservableImpl observable;
    private int[] image_data;

    public VicScreen(int pixel_width, int width, int pixel_height, int height) {
        super(width, height, 2);
        int[] nArray = new int[16];
        nArray[1] = 0xFFFFFF;
        nArray[2] = 0xF00000;
        nArray[3] = 61680;
        nArray[4] = 0x600060;
        nArray[5] = 40960;
        nArray[6] = 240;
        nArray[7] = 0xD0D000;
        nArray[8] = 0xC0A000;
        nArray[9] = 0xFFA000;
        nArray[10] = 0xF08080;
        nArray[11] = 65535;
        nArray[12] = 0xFF00FF;
        nArray[13] = 65280;
        nArray[14] = 41215;
        nArray[15] = 0xFFFF00;
        this.colors = nArray;
        this.observable = new ObservableImpl();
        this.pixel_size = new Dimension(pixel_width, pixel_height);
        this.screen_size = new Dimension(width, height);
        int i = 0;
        while (i < this.colors.length) {
            int n = i++;
            this.colors[n] = this.colors[n] | 0xFF000000;
        }
        WritableRaster wRas = this.getRaster();
        DataBufferInt dbInt = (DataBufferInt)wRas.getDataBuffer();
        this.image_data = dbInt.getData(0);
    }

    public synchronized void lock() {
        while (this.lock > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ++this.lock;
    }

    public synchronized void unlock() {
        --this.lock;
        this.notifyAll();
    }

    @Override
    public void putPixel(int x, int y, int color) {
        this.putPixel(x, y, color, 1);
    }

    @Override
    public void putPixel(int x, int y, int color, int x_width) {
        this.lock();
        try {
            int line_start = y * this.pixel_size.height * this.screen_size.width + x * this.pixel_size.width;
            int i_y = 0;
            while (i_y < this.pixel_size.height) {
                int index = line_start;
                int i_x = 0;
                while (i_x < x_width * this.pixel_size.width) {
                    this.image_data[index++] = this.colors[color & 0xF];
                    ++i_x;
                }
                line_start += this.screen_size.width;
                ++i_y;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.unlock();
    }

    @Override
    public void showScreen() {
        this.observable.doNotify();
    }

    public void addObserver(Observer arg0) {
        this.observable.addObserver(arg0);
    }

    class ObservableImpl
    extends Observable {
        ObservableImpl() {
        }

        public void doNotify() {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

